//
//  DatePicker.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 01/09/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
class DatePicker: UIView, UITextFieldDelegate {
    var textField: UITextField!
    var pickerView: UIDatePicker!
    var isTimeRequired = false

    var text = ""
    var timestamp = 0

    func initDatePickerWithTime(shouldShowTime: Bool, frame: CGRect) -> AnyObject {
        super.init(frame: frame)
        
        isTimeRequired = shouldShowTime
        self.initialize()
    
    }
    var dateFormatter: NSDateFormatter!



    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.initialize()
    
    }

    override func initialize() {
        if isTimeRequired {
            dateFormatter = NSDateFormatter()
            dateFormatter.dateFormat = NSDateFormatter.dateFormatFromTemplate("yyyy-MM-dd hh:mm:ss", options: [], locale: NSLocale.systemLocale())!
        }
        else {
            dateFormatter = NSDateFormatter()
            dateFormatter.dateFormat = NSDateFormatter.dateFormatFromTemplate("yyyy-MM-dd", options: [], locale: NSLocale.systemLocale())!
        }
        textField = UITextField(frame: CGRectMake(0, 0, self.frame.size.width, self.frame.size.height))
        textField.borderStyle = .RoundedRect
        textField.addTarget(self, action: (self.showPicker), forControlEvents: .TouchDown)
        textField.delegate = self
        textField.text = "Select Date"
        textField.tag = 111
        self.addSubview(textField)
        self.timestamp = 0
    }

    @IBAction func showPicker(sender: AnyObject) {
        pickerView == nil ? pickerView[UIDatePicker] : ""
        if isTimeRequired {
            pickerView.datePickerMode = .DateAndTime
        }
        else {
            pickerView.datePickerMode = .Date
        }
        pickerView.addTarget(self, action: (self.dateChanged), forControlEvents: .ValueChanged)
        var toolbar = UIToolbar()
        toolbar.barStyle = .BlackTranslucent
        toolbar.sizeToFit()
        var flexibleSpaceLeft = UIBarButtonItem(barButtonSystemItem: .FlexibleSpace, target: nil, action: nil)
        var doneButton = UIBarButtonItem(title: "Done", style: .Done, target: self, action: (self.doneClicked))
        toolbar.items = [flexibleSpaceLeft, doneButton]
        //custom input view
        textField.inputView = pickerView
        textField.inputAccessoryView! = toolbar
    }

    func doneClicked(sender: AnyObject) {
        textField.text = dateFormatter.stringFromDate(pickerView.date!)
        self.text = textField.text
        self.timestamp = pickerView.date!.timeIntervalSince1970
        textField.resignFirstResponder()
        //hides the pickerView
    }

    @IBAction func dateChanged(sender: AnyObject) {
        textField.text = dateFormatter.stringFromDate(pickerView.date!)
        self.text = textField.text
        self.timestamp = pickerView.date!.timeIntervalSince1970
    }

    func textFieldShouldBeginEditing(aTextField: UITextField) -> Bool {
        self.showPicker(aTextField)
        return true
    }

    func textField(textField: UITextField, shouldChangeCharactersInRange range: NSRange, replacementString string: String) -> Bool {
        return false
    }
}